# 📝 Mini CMS - ระบบจัดการบทความ

ระบบจัดการบทความแบบง่ายที่มีฟังก์ชัน CRUD ครบถ้วน เหมาะสำหรับเริ่มต้นเรียนรู้การพัฒนาเว็บแบบ Full-Stack

## ✨ ฟีเจอร์

- ✅ แสดงรายการบทความทั้งหมด
- ✅ เพิ่มบทความใหม่
- ✅ แก้ไขบทความที่มีอยู่
- ✅ ลบบทความ
- ✅ ค้นหาบทความจากชื่อและเนื้อหา
- ✅ กรองบทความตามหมวดหมู่
- ✅ แสดงข้อมูลผู้เขียนและวันที่
- ✅ Responsive Design
- ✅ Auto-save draft
- ✅ Character counter

## 🛠️ เทคโนโลยีที่ใช้

- **Frontend:** HTML5, CSS3, JavaScript (Vanilla)
- **Backend:** PHP 7.4+
- **Database:** MySQL 5.7+
- **Server:** Apache (XAMPP/WAMP)

## 📋 ความต้องการของระบบ

- PHP 7.4 หรือสูงกว่า
- MySQL 5.7 หรือสูงกว่า
- Apache Web Server
- XAMPP หรือ WAMP (แนะนำ)

## 🚀 การติดตั้ง

### 1. ติดตั้ง XAMPP/WAMP

ดาวน์โหลดและติดตั้ง XAMPP จาก [https://www.apachefriends.org/](https://www.apachefriends.org/)

### 2. คัดลอกไฟล์โปรเจ็ค

คัดลอกโฟลเดอร์ `mini-cms` ไปยัง:
- XAMPP: `C:\xampp\htdocs\mini-cms`
- WAMP: `C:\wamp64\www\mini-cms`

### 3. สร้างฐานข้อมูล

1. เปิด phpMyAdmin: `http://localhost/phpmyadmin`
2. สร้างฐานข้อมูลใหม่ชื่อ `mini_cms_db`
3. รัน SQL ด้านล่างนี้:

```sql
CREATE DATABASE IF NOT EXISTS mini_cms_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE mini_cms_db;

CREATE TABLE articles (
    id INT(11) PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    author VARCHAR(100) DEFAULT 'ไม่ระบุชื่อ',
    category VARCHAR(50) DEFAULT 'ทั่วไป',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category (category),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- เพิ่มข้อมูลตัวอย่าง
INSERT INTO articles (title, content, author, category) VALUES
('การเริ่มต้นเรียนรู้ HTML', 'HTML (HyperText Markup Language) เป็นภาษามาร์กอัปที่ใช้สำหรับสร้างโครงสร้างเว็บเพจ เป็นพื้นฐานสำคัญที่ทุกคนที่ต้องการสร้างเว็บไซต์ควรเรียนรู้\n\nHTML ประกอบด้วย Elements ต่างๆ ที่ใช้กำหนดโครงสร้างเนื้อหา เช่น หัวข้อ ย่อหน้า รูปภาพ ลิงก์ และอื่นๆ อีกมากมาย', 'สมชาย ใจดี', 'HTML'),
('CSS: ทำให้เว็บไซต์สวยงาม', 'CSS (Cascading Style Sheets) เป็นภาษาที่ใช้ในการตกแต่งและจัดรูปแบบหน้าเว็บ ทำให้เว็บไซต์ดูสวยงามและน่าสนใจ\n\nด้วย CSS เราสามารถกำหนดสี ฟอนต์ ระยะห่าง การจัดวาง และเอฟเฟกต์ต่างๆ ได้อย่างอิสระ', 'สมหญิง รักเรียน', 'CSS'),
('JavaScript เบื้องต้น', 'JavaScript เป็นภาษาโปรแกรมที่ทำให้เว็บไซต์มีความโต้ตอบและมีชีวิตชีวา สามารถสร้างฟีเจอร์ต่างๆ เช่น การตรวจสอบฟอร์ม การแสดงผลแบบไดนามิก', 'วิชัย โค้ดดี', 'JavaScript');
```

### 4. ตั้งค่าการเชื่อมต่อฐานข้อมูล

แก้ไขไฟล์ `config.php` ถ้าจำเป็น:

```php
$host = "localhost";
$db_user = "root";
$db_pass = "";  // ใส่รหัสผ่านถ้ามี
$db_name = "mini_cms_db";
```

### 5. เปิดใช้งาน

เปิดเบราว์เซอร์และไปที่: `http://localhost/mini-cms/`

## 📁 โครงสร้างไฟล์

```
mini-cms/
├── config.php          # การตั้งค่าฐานข้อมูล
├── index.php           # หน้าแรก - แสดงรายการบทความ
├── create.php          # หน้าเพิ่มบทความ
├── edit.php            # หน้าแก้ไขบทความ
├── view.php            # หน้าแสดงบทความแบบเต็ม
├── delete.php          # สคริปต์ลบบทความ
├── styles/
│   └── main.css        # ไฟล์ CSS หลัก
├── scripts/
│   └── main.js         # ไฟล์ JavaScript
└── README.md           # เอกสารนี้
```

## 💡 การใช้งาน

### เพิ่มบทความ
1. คลิกปุ่ม "+ เพิ่มบทความใหม่"
2. กรอกข้อมูล: ชื่อบทความ, ผู้เขียน, หมวดหมู่, เนื้อหา
3. คลิก "บันทึกบทความ"

### ค้นหาบทความ
1. พิมพ์คำค้นหาในช่องค้นหา
2. เลือกหมวดหมู่ (ถ้าต้องการ)
3. คลิก "ค้นหา"

### แก้ไขบทความ
1. คลิกปุ่ม "แก้ไข" ที่บทความที่ต้องการ
2. แก้ไขข้อมูล
3. คลิก "บันทึกการแก้ไข"

### ลบบทความ
1. คลิกปุ่ม "ลบ" ที่บทความที่ต้องการ
2. ยืนยันการลบ

## 🔒 ความปลอดภัย

โปรเจ็คนี้ใช้มาตรการความปลอดภัยพื้นฐาน:

- ✅ Prepared Statements (ป้องกัน SQL Injection)
- ✅ htmlspecialchars() (ป้องกัน XSS)
- ✅ Input Sanitization
- ✅ mysqli_real_escape_string()

**หมายเหตุ:** นี่เป็นโปรเจ็คสำหรับการเรียนรู้ ไม่แนะนำให้ใช้งานจริงโดยไม่เพิ่มความปลอดภัยเพิ่มเติม

## 🎨 การปรับแต่ง

### เปลี่ยนสีธีม
แก้ไขไฟล์ `styles/main.css`:

```css
/* เปลี่ยน gradient สี */
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
```

### เพิ่มหมวดหมู่
แก้ไขไฟล์ `create.php` และ `edit.php`:

```html
<option value="หมวดหมู่ใหม่">หมวดหมู่ใหม่</option>
```

## 🚀 การพัฒนาต่อยอด

### ฟีเจอร์ที่แนะนำ
- [ ] ระบบ Login/Authentication
- [ ] การอัปโหลดรูปภาพ
- [ ] Pagination (แบ่งหน้า)
- [ ] Rich Text Editor (WYSIWYG)
- [ ] ระบบคอมเมนต์
- [ ] การแชร์โซเชียลมีเดีย
- [ ] SEO-friendly URLs
- [ ] Export เป็น PDF

### เทคโนโลยีที่แนะนำ
- **Framework:** Laravel, CodeIgniter
- **Frontend:** React, Vue.js
- **Database:** PostgreSQL, MongoDB
- **Deployment:** Docker, AWS, DigitalOcean

## 🐛 การแก้ไขปัญหา

### ไม่สามารถเชื่อมต่อฐานข้อมูล
- ตรวจสอบว่า MySQL เปิดอยู่
- ตรวจสอบ username/password ใน `config.php`
- ตรวจสอบว่าสร้างฐานข้อมูล `mini_cms_db` แล้ว

### ภาษาไทยแสดงผลเป็นอักขระแปลกๆ
- ตรวจสอบว่าตาราง charset เป็น `utf8mb4`
- ตรวจสอบว่าไฟล์ PHP บันทึกเป็น UTF-8

### หน้าเว็บแสดงผลไม่ถูกต้อง
- ตรวจสอบ path ของ CSS และ JS
- เปิด Developer Tools (F12) ดู Console errors

## 📚 แหล่งเรียนรู้เพิ่มเติม

- [PHP Manual](https://www.php.net/manual/en/)
- [MySQL Documentation](https://dev.mysql.com/doc/)
- [MDN Web Docs](https://developer.mozilla.org/)
- [W3Schools](https://www.w3schools.com/)

## 📝 License

โปรเจ็คนี้เป็น Open Source สามารถนำไปใช้และแก้ไขได้ตามต้องการ

## 👨‍💻 ผู้พัฒนา

สร้างขึ้นเพื่อการเรียนรู้ Web Development

---

**Happy Coding! 🎉**
