-- ===================================
-- Mini CMS Database Setup
-- ===================================

-- สร้างฐานข้อมูล
CREATE DATABASE IF NOT EXISTS mini_cms_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE mini_cms_db;

-- ลบตารางเดิม (ถ้ามี)
DROP TABLE IF EXISTS articles;

-- สร้างตาราง articles
CREATE TABLE articles (
    id INT(11) PRIMARY KEY AUTO_INCREMENT,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    author VARCHAR(100) DEFAULT 'ไม่ระบุชื่อ',
    category VARCHAR(50) DEFAULT 'ทั่วไป',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category (category),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- เพิ่มข้อมูลตัวอย่าง
INSERT INTO articles (title, content, author, category) VALUES
(
    'การเริ่มต้นเรียนรู้ HTML',
    'HTML (HyperText Markup Language) เป็นภาษามาร์กอัปที่ใช้สำหรับสร้างโครงสร้างเว็บเพจ เป็นพื้นฐานสำคัญที่ทุกคนที่ต้องการสร้างเว็บไซต์ควรเรียนรู้

HTML ประกอบด้วย Elements ต่างๆ ที่ใช้กำหนดโครงสร้างเนื้อหา เช่น หัวข้อ ย่อหน้า รูปภาพ ลิงก์ และอื่นๆ อีกมากมาย

องค์ประกอบพื้นฐานของ HTML:
- Tags: ใช้กำหนดโครงสร้าง เช่น <h1>, <p>, <div>
- Attributes: คุณสมบัติของ element เช่น class, id, src
- Content: เนื้อหาที่อยู่ภายใน tags

การเรียนรู้ HTML เป็นก้าวแรกสู่การเป็น Web Developer',
    'สมชาย ใจดี',
    'HTML'
),
(
    'CSS: ทำให้เว็บไซต์สวยงาม',
    'CSS (Cascading Style Sheets) เป็นภาษาที่ใช้ในการตกแต่งและจัดรูปแบบหน้าเว็บ ทำให้เว็บไซต์ดูสวยงามและน่าสนใจ

ด้วย CSS เราสามารถกำหนดสี ฟอนต์ ระยะห่าง การจัดวาง และเอฟเฟกต์ต่างๆ ได้อย่างอิสระ รวมถึงการทำ Responsive Design เพื่อรองรับหน้าจอขนาดต่างๆ

หัวข้อสำคัญใน CSS:
- Selectors: เลือก element ที่ต้องการจัดรูปแบบ
- Properties: คุณสมบัติที่ต้องการกำหนด เช่น color, font-size
- Box Model: การจัดการขนาดและระยะห่าง
- Flexbox & Grid: เทคนิคการจัดวาง layout
- Responsive Design: ปรับตัวตามขนาดหน้าจอ

CSS ทำให้เว็บไซต์มีชีวิตชีวาและดึงดูดผู้ใช้งาน',
    'สมหญิง รักเรียน',
    'CSS'
),
(
    'JavaScript เบื้องต้น',
    'JavaScript เป็นภาษาโปรแกรมที่ทำให้เว็บไซต์มีความโต้ตอบและมีชีวิตชีวา สามารถสร้างฟีเจอร์ต่างๆ เช่น การตรวจสอบฟอร์ม การแสดงผลแบบไดนามิก และการเชื่อมต่อกับ API

JavaScript ทำงานบนฝั่ง Client (เบราว์เซอร์) และสามารถจัดการ DOM (Document Object Model) เพื่อเปลี่ยนแปลงเนื้อหาหน้าเว็บแบบ Real-time

แนวคิดสำคัญใน JavaScript:
- Variables & Data Types: การเก็บข้อมูล
- Functions: การสร้างฟังก์ชันทำงาน
- Events: การตอบสนองต่อการกระทำของผู้ใช้
- DOM Manipulation: การจัดการ HTML elements
- AJAX & Fetch API: การดึงข้อมูลจาก server

JavaScript เป็นหัวใจสำคัญของ Modern Web Development',
    'วิชัย โค้ดดี',
    'JavaScript'
),
(
    'PHP และ MySQL: Backend Development',
    'PHP เป็นภาษาโปรแกรมฝั่งเซิร์ฟเวอร์ที่นิยมใช้ในการพัฒนาเว็บไซต์ ทำงานร่วมกับ MySQL ซึ่งเป็นระบบจัดการฐานข้อมูล

ด้วย PHP และ MySQL เราสามารถสร้างระบบที่มีการจัดเก็บข้อมูล เช่น ระบบสมาชิก ระบบบทความ ระบบร้านค้าออนไลน์ และอื่นๆ อีกมากมาย

ความสามารถของ PHP:
- ประมวลผลฟอร์ม
- จัดการ Session และ Cookie
- เชื่อมต่อฐานข้อมูล
- สร้าง API
- จัดการไฟล์และรูปภาพ

MySQL ช่วยในการ:
- จัดเก็บข้อมูลอย่างเป็นระบบ
- Query ข้อมูลได้รวดเร็ว
- รองรับข้อมูลจำนวนมาก
- มีความปลอดภัยสูง',
    'ประยุทธ์ เว็บมาสเตอร์',
    'PHP'
),
(
    'Responsive Web Design',
    'Responsive Web Design คือการออกแบบเว็บไซต์ให้สามารถปรับตัวแสดงผลได้ดีบนอุปกรณ์ทุกขนาด ไม่ว่าจะเป็นมือถือ แท็บเล็ต หรือคอมพิวเตอร์

เทคนิคสำคัญ ได้แก่ การใช้ Media Queries, Flexible Grid Layout, และ Flexible Images เพื่อให้เว็บไซต์มีประสบการณ์การใช้งานที่ดีบนทุกอุปกรณ์

หลักการ Responsive Design:
- Mobile First: ออกแบบสำหรับมือถือก่อน
- Flexible Grid: ใช้ % แทน px
- Media Queries: ปรับ CSS ตามขนาดหน้าจอ
- Flexible Images: รูปภาพปรับขนาดอัตโนมัติ
- Touch-Friendly: ปุ่มและลิงก์ขนาดเหมาะสม

ในยุคที่คนใช้มือถือมากขึ้น Responsive Design จึงเป็นสิ่งจำเป็น',
    'สุดา ดีไซน์เนอร์',
    'CSS'
),
(
    'เทคนิคการเขียน SQL ที่มีประสิทธิภาพ',
    'SQL (Structured Query Language) เป็นภาษาที่ใช้ในการจัดการฐานข้อมูล การเขียน SQL ที่ดีจะช่วยให้ระบบทำงานได้เร็วและมีประสิทธิภาพ

เทคนิคสำคัญ เช่น การใช้ Index, การหลีกเลี่ยง SELECT *, การใช้ JOIN อย่างถูกต้อง และการเขียน Query ที่เหมาะสมกับโครงสร้างฐานข้อมูล

เทคนิคเพิ่มประสิทธิภาพ:
- ใช้ INDEX สำหรับ column ที่ค้นหาบ่อย
- หลีกเลี่ยง SELECT * ระบุ column ที่ต้องการ
- ใช้ LIMIT จำกัดจำนวนผลลัพธ์
- ใช้ Prepared Statements ป้องกัน SQL Injection
- Optimize JOIN queries
- ใช้ EXPLAIN เพื่อวิเคราะห์ query

การเขียน SQL ที่ดีช่วยให้เว็บไซต์โหลดเร็วและรองรับผู้ใช้ได้มากขึ้น',
    'ชัยวัฒน์ ดาต้าเบส',
    'PHP'
);

-- แสดงข้อมูลที่เพิ่มเข้าไป
SELECT * FROM articles ORDER BY created_at DESC;

-- แสดงจำนวนบทความในแต่ละหมวดหมู่
SELECT category, COUNT(*) as total FROM articles GROUP BY category;
