<?php
include 'config.php';

// รับค่าการค้นหาและหมวดหมู่
$search = isset($_GET['search']) ? sanitize($_GET['search']) : '';
$category = isset($_GET['category']) ? sanitize($_GET['category']) : '';

// สร้าง SQL Query ด้วย Prepared Statement
$sql = "SELECT id, title, content, author, category, created_at FROM articles WHERE 1=1";
$params = [];

if (!empty($search)) {
    $sql .= " AND (title LIKE :search OR content LIKE :search)";
    $params['search'] = "%$search%";
}

if (!empty($category)) {
    $sql .= " AND category = :category";
    $params['category'] = $category;
}

$sql .= " ORDER BY created_at DESC";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $articles = $stmt->fetchAll();

    // ดึงหมวดหมู่ทั้งหมด
    $categories_stmt = $pdo->query("SELECT DISTINCT category FROM articles ORDER BY category");
    $categories = $categories_stmt->fetchAll();

} catch (PDOException $e) {
    die("Error: ".$e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mini CMS - ระบบจัดการบทความ</title>
    <link rel="stylesheet" href="styles/main.css">
</head>
<body>
    <div class="container">
        <header class="site-header">
            <h1>📝 Mini CMS</h1>
            <p class="tagline">ระบบจัดการบทความแบบง่าย</p>
        </header>

        <div class="toolbar">
            <a href="create.php" class="button-primary">+ เพิ่มบทความใหม่</a>
            <a href="../../2lesson/7project" class="button-secondary">← กลับหน้าโปรเจ็ค</a>
        </div>

        <!-- ฟอร์มค้นหาและกรอง -->
        <div class="search-filter">
            <form method="GET" action="index.php" class="search-form">
                <input type="text" name="search" placeholder="ค้นหาบทความ..." value="<?php echo htmlspecialchars($search); ?>" class="search-input">
                <select name="category" class="category-select">
                    <option value="">ทุกหมวดหมู่</option>
                    <?php foreach ($categories as $cat): ?>
                        <option value="<?php echo htmlspecialchars($cat['category']); ?>" <?php echo($category == $cat['category']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($cat['category']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <button type="submit" class="button-search">🔍 ค้นหา</button>
                <?php if (!empty($search) || !empty($category)): ?>
                    <a href="index.php" class="button-clear">✕ ล้าง</a>
                <?php endif; ?>
            </form>
        </div>

        <!-- แสดงผลลัพธ์การค้นหา -->
        <?php if (!empty($search) || !empty($category)): ?>
            <div class="search-result">
                พบ <?php echo count($articles); ?> บทความ
                <?php if (!empty($search)): ?>
                    สำหรับ "<strong><?php echo htmlspecialchars($search); ?></strong>"
                <?php endif; ?>
                <?php if (!empty($category)): ?>
                    ในหมวดหมู่ "<strong><?php echo htmlspecialchars($category); ?></strong>"
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <!-- รายการบทความ -->
        <div class="articles-container">
            <?php
if (count($articles) > 0) {
    foreach ($articles as $row) {
        $excerpt = mb_substr(strip_tags($row["content"]), 0, 150);
        ?>
                    <article class="article-card">
                        <div class="article-header">
                            <h2 class="article-title">
                                <a href="view.php?id=<?php echo $row["id"]; ?>">
                                    <?php echo htmlspecialchars($row["title"]); ?>
                                </a>
                            </h2>
                            <span class="category-badge"><?php echo htmlspecialchars($row["category"]); ?></span>
                        </div>
                        <div class="article-meta">
                            <span class="author">👤 <?php echo htmlspecialchars($row["author"]); ?></span>
                            <span class="date">📅 <?php echo date('d/m/Y H:i', strtotime($row["created_at"])); ?></span>
                        </div>
                        <p class="article-excerpt"><?php echo htmlspecialchars($excerpt); ?>...</p>
                        <div class="article-actions">
                            <a href="view.php?id=<?php echo $row["id"]; ?>" class="button-view">อ่านต่อ</a>
                            <a href="edit.php?id=<?php echo $row["id"]; ?>" class="button-edit">แก้ไข</a>
                            <a href="delete.php?id=<?php echo $row["id"]; ?>&csrf_token=<?php echo generateCsrfToken(); ?>"
                               class="button-delete"
                               onclick="return confirm('แน่ใจหรือไม่ที่จะลบบทความนี้?')">ลบ</a>
                        </div>
                    </article>
                    <?php
}
} else {
    echo '<div class="no-articles">
                        <div class="no-articles-icon">📭</div>
                        <h3>ไม่พบบทความ</h3>
                        <p>ลองค้นหาด้วยคำอื่น หรือ <a href="create.php">เพิ่มบทความใหม่</a></p>
                      </div>';
}
?>
        </div>
    </div>

    <script src="scripts/main.js"></script>
</body>
</html>
