<?php
include 'config.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    redirect('index.php');
}

// ดึงข้อมูลบทความ
try {
    $stmt = $pdo->prepare("SELECT id, title, content, author, category, created_at, updated_at FROM articles WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $article = $stmt->fetch();

    if (!$article) {
        redirect('index.php');
    }
} catch(PDOException $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($article['title']); ?> - Mini CMS</title>
    <link rel="stylesheet" href="styles/main.css">
</head>
<body>
    <div class="container">
        <header class="site-header">
            <h1>📝 Mini CMS</h1>
        </header>

        <div class="toolbar">
            <a href="index.php" class="button-secondary">← กลับหน้าแรก</a>
            <a href="edit.php?id=<?php echo $article['id']; ?>" class="button-edit">✏️ แก้ไข</a>
            <a href="delete.php?id=<?php echo $article['id']; ?>"
               class="button-delete"
               onclick="return confirm('แน่ใจหรือไม่ที่จะลบบทความนี้?')">🗑️ ลบ</a>
        </div>

        <article class="article-full">
            <header class="article-full-header">
                <h1 class="article-full-title"><?php echo htmlspecialchars($article['title']); ?></h1>
                <div class="article-full-meta">
                    <span class="category-badge"><?php echo htmlspecialchars($article['category']); ?></span>
                    <span class="author">👤 <?php echo htmlspecialchars($article['author']); ?></span>
                    <span class="date">📅 <?php echo date('d/m/Y H:i', strtotime($article['created_at'])); ?></span>
                    <?php if ($article['updated_at'] != $article['created_at']): ?>
                        <span class="updated">🔄 แก้ไขล่าสุด: <?php echo date('d/m/Y H:i', strtotime($article['updated_at'])); ?></span>
                    <?php endif; ?>
                </div>
            </header>

            <div class="article-full-content">
                <?php echo nl2br(htmlspecialchars($article['content'])); ?>
            </div>
        </article>

        <div class="article-navigation">
            <a href="index.php" class="button-primary">← กลับหน้าแรก</a>
        </div>
    </div>

    <script src="scripts/main.js"></script>
</body>
</html>
